<?php
class tuan
{
	private $db;
	private $tuan_table;
	private $type_table;
	private $comment_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->tuan_table=LA_PRE.'tuan';
		$this->type_table=LA_PRE.'tuan_type';
		$this->comment_table=LA_PRE.'tuan_comment';
	}

	function tuanlist($userid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where=$userid?' userid='.$userid:'1';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND updatetime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND updatetime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND name LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->tuan_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function formattuanurl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;
		
		$id=intval($id);

		$key='key-tuan-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(18);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],18);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'goods-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=show&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/goods-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=show&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function gettuan($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->tuan_table` WHERE `$this->tuan_table`.`id`=$id");
	}

	function goodsstatis($moduleid=7,$status=-1)
	{
		global $siteidobj,$_siteid;
		$moduleid=intval($moduleid);
		$status=intval($status);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->tuan_table` WHERE $where");
	}

	function tuanset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->gettuan($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->tuan_table.'_data',$id,$modelobj->subformcount2($cinfo['modelid']));
					$this->db->update($this->tuan_table,$info,'id='.$id);
					$this->db->update($hash_table,$info,'mid='.$id);
				}
			}
		}
		return true;
	}

	function tuan_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->gettuan($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->tuan_table.'_data',$id,$modelobj->subformcount2($cinfo['modelid']));
					$this->db->mysql_delete($this->tuan_table,$id);
					$this->db->mysql_delete($hash_table,$id,'mid');
				}
			}
		}
		return true;
	}

	function tuan_settop($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;
		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);

		$tiao=$settings['top_type']==0?$_point:$_amount;
		if($settings['top_fee']<=$tiao)
		{
			if($settings['top_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['top_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['top_fee'])));
			}
			return $this->db->query("UPDATE `$this->tuan_table` SET `$this->tuan_table`.`istop`='".(TIME+24*3600)."' WHERE `$this->tuan_table`.`id`=$id AND  `$this->tuan_table`.`userid`=$userid");
		}
		
		return false;
	}

	function tuan_setdelete($id,$userid)
	{
		$id=intval($id);
		$userid=intval($userid);
		return $this->db->query("DELETE FROM `$this->tuan_table` WHERE `$this->tuan_table`.`id`=$id AND  `$this->tuan_table`.`userid`=$userid");
	}

	function tuan_refresh($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;

		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);
		
		$tiao=$settings['pay_type']==0?$_point:$_amount;
		if($settings['pay_fee']<=$tiao)
		{
			if($settings['pay_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['pay_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['pay_fee'])));
			}

			$this->db->query("UPDATE `$this->tuan_table` SET `$this->tuan_table`.`updatetime`=".TIME." WHERE `$this->tuan_table`.`id`=$id AND  `$this->tuan_table`.`userid`=$userid");
			return true;
		}
		return false;
	}

	function member_tuan_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['updatetime']=TIME;
		$info['clicks']=0;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['userid']=$_userid;
		$info['ip']=IP;

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		
		$tiao=$settings['pay_type']==0?$_point:$_amount;
		if($settings['pay_fee']<=$tiao)
		{
			if($settings['pay_type']==0)
			{
				$memberobj->set($_userid,array('point'=>max(0,$_point-$settings['pay_fee'])));
			}
			else
			{
				$memberobj->set($_userid,array('amount'=>max(0,$_amount-$settings['pay_fee'])));
			}
			$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
			$this->db->insert($hash_table,$info,true);
		}
		else
		{
			return false;
		}
		
		$cacheobj->clear();
		return true;
	}

	function buyer_comment_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->commentinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					if(!$userid || $userid==$cinfo['comuserid'])
					{
						$this->db->mysql_delete($this->comment_table,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function seller_comment_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->commentinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					if(!$userid || $userid==$cinfo['tuanuserid'])
					{
						$this->db->mysql_delete($this->comment_table,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function ask_reply($reply,$id)
	{
		$id=intval($id);
		$cinfo=$this->commentinfo($id);
		if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		else
		{
			if(!$userid || $userid==$cinfo['tuanuserid'])
			{
				return $this->db->update($this->comment_table,array('reply'=>strip_tags($reply)),'id='.intval($id));
			}
		}

		return false;
	}


	function member_tuan_edit($info,$modelid=0,$extend=0,$id)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$_userid,$_gradeid,$_point,$_amount,$conobj,$memberobj;
		$info['modelid']=intval($modelid);
		$id=intval($id);
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		
		$info['updatetime']=TIME;
		$info['ip']=IP;

		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));

		
		$tiao=$settings['pay_type']==0?$_point:$_amount;
		if($settings['pay_fee']<=$tiao)
		{
			if($settings['pay_type']==0)
			{
				$memberobj->set($_userid,array('point'=>max(0,$_point-$settings['pay_fee'])));
			}
			else
			{
				$memberobj->set($_userid,array('amount'=>max(0,$_amount-$settings['pay_fee'])));
			}
			$this->db->update(LA_PRE.$modelinfo['tbname'],$info,'id='.$id);
			$this->db->update($hash_table,$info,'mid='.$id);
		}
		else
		{
			return false;
		}
		
		$cacheobj->clear();
		return true;
	}

	function admin_tuan_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);
	
		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$mem=$info;
		$mem['gradeid']=3;
		$mem['username']='company_'.TIME;
		$mem['password']=md5(mt_rand(100000,999999));
		$mem['email']='company_'.TIME.'@niubicms.com';
		$mem['company']=$info['name'];
		$info['userid']=$memberobj->admin_companyadd($mem);

		$info['updatetime']=TIME;
		$info['ip']=IP;
		$info['status']=1;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}

	function admin_tuan_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		$info['updatetime']=TIME;

		$info['siteid']=intval($_SESSION['siteid']);
		$this->db->update($this->tuan_table,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}
	
	function typelist($moduleid=0,$typeid=0)
	{
		global $page,$_siteid,$siteidobj;
		$moduleid=intval($moduleid);
		$typeid=intval($typeid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$typeid?' AND parentid='.$typeid:' AND parentid=0';
		$where.=$moduleid?' AND moduleid='.$moduleid:'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='orderby ASC ,typeid ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=25;
		$result=$datalist->getlist($this->type_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function typesqlids($typeid=0)
	{
		$re=array(intval($typeid));
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`parentid`=".intval($typeid)." OR  `$this->type_table`.`grandparentid`=".intval($typeid));
		if($r)foreach($r as $_r)
		{
			$re[]=$_r['typeid'];
		}

		return array_unique($re);
	}

	function type_add($info)
	{
		$info['modelid']=63;
		$info['grandparentid']=$info['parentid']?$this->typeparentid($info['parentid']):0;
		$info['siteid']=intval($_SESSION['siteid']);

		$names=array_map('trim',explode("|",$info['name']));
		foreach($names as $name)
		{
			if($name)
			{
				$info['name']=strip_tags($name);
				$this->db->insert($this->type_table,$info);
			}
		}
		return true;
	}

	function type_delete($id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$this->db->mysql_delete($this->type_table,intval($id),'typeid');
		$this->db->mysql_delete($this->type_table,intval($id),'parentid');
		$this->db->mysql_delete($this->type_table,intval($id),'grandparentid');
		return true;
	}

	function gettypeid($moduleid=7)
	{
		$r=$this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`typeid` ASC");
		return $r?$r['typeid']:0;
	}

	function type_edit($info,$id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		$info['grandparentid']=$info['parentid']?$this->typeparentid($info['parentid']):0;
		return $this->db->update($this->type_table,$info,'typeid='.intval($id));
	}

	function typeinfo($id)
	{
		return $this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`typeid`=".intval($id));
	}

	function typename($id)
	{
		$r=$this->typeinfo($id);
		return $r['name'];
	}

	function parenttypename($id)
	{
		$pid=$this->typeparentid($id);
		$r=$pid?$this->typeinfo($pid):array('name'=>'');
		return $r['name'];
	}

	function typeparentid($id)
	{
		$r=$this->typeinfo($id);
		return $r['parentid'];
	}

	function type_select($moduleid=7,$parentid=0,$g=3)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." AND `$this->type_table`.`parentid`=".intval($parentid)." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
		foreach($r as $_r)
		{
			if($g>=2)
			{
				$r2=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." AND `$this->type_table`.`parentid`=".intval($_r['typeid'])." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
				if($r2)
				{
					$str.='<optgroup label="'.$_r['name'].'">';
					foreach($r2 as $_r2)
					{
						if($g>=3)
						{
							$r3=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." AND `$this->type_table`.`parentid`=".intval($_r2['typeid'])." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
							if($r3)
							{
								$str.='<option value="'.$_r2['typeid'].'" disabled="disabled">'.$_r2['name'].'</option>';
								foreach($r3 as $_r3)
								{
									$str.='<option value="'.$_r3['typeid'].'">|--'.$_r3['name'].'</option>';
								}
							}
							else
							{
								$str.='<option value="'.$_r2['typeid'].'">'.$_r2['name'].'</option>';
							}
						}
						else
						{
							$str.='<option value="'.$_r2['typeid'].'">'.$_r2['name'].'</option>';
						}
					}
					$str.='</optgroup>';
				}
				else
				{
					$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
				}
			}
			else
			{
				$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
			}
		}

		return $str;
	}

	function type_select_cat($moduleid=7,$parentid=0)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." AND `$this->type_table`.`parentid`=".intval($parentid)." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
		foreach($r as $_r)
		{
			$r2=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." AND `$this->type_table`.`parentid`=".intval($_r['typeid'])." ORDER BY `$this->type_table`.`orderby` ASC,`$this->type_table`.`typeid` ASC");
			if($r2)
			{
				$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
				foreach($r2 as $_r2)
				{
					$str.='<option value="'.$_r2['typeid'].'">|--'.$_r2['name'].'</option>';
				}
				$str.='</option>';
			}
			else
			{
				$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
			}
		}

		return $str;
	}

	function tuancommentlist($tuanid=0,$status=-1,$starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where=$tuanid?' tuanuserid='.$tuanid:'1';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND content LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->comment_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function commentinfo($commentid)
	{	
		$commentid=intval($commentid);
		return $this->db->fetch_one("SELECT * FROM `$this->comment_table` WHERE `$this->comment_table`.`id`=$commentid");
	}

	function comment_set($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->commentinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->comment_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function comment_delete($ids=array(),$userid=0)
	{
		global $settings,$_siteid,$siteidobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->commentinfo($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$coninfo=$this->gettuan($cinfo['tuanid']);
					if(!$userid || $userid==$coninfo['userid'])
					{
						$this->db->mysql_delete($this->comment_table,$id,'id');
					}
				}
			}
		}

		return true;
	}

	function commentstatis($tuanid=0,$status=-1,$userid=0)
	{
		global $siteidobj,$_siteid;
		$tuanid=intval($tuanid);
		$status=intval($status);
		$userid=intval($userid);

		$where='1';
		$where.=$_siteid?' AND siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'';
		$where.=$status>=0?' AND status='.$status:'';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$tuanid?' AND tuanid='.$tuanid:'';
		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->comment_table` WHERE $where");
	}

	function buyerasklist($userid=0,$status=-1)
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND comuserid='.$userid:'';
		$where.=$status>-1?' AND status='.$status:'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->comment_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function sellerasklist($userid=0,$status=-1)
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$userid?' AND tuanuserid='.$userid:'';
		$where.=$status>-1?' AND status='.$status:'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->comment_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}
}
?>
